//////////////////////////////////////////////////////////////////////////////
//
//  Copyright 2013 by Autodesk, Inc.  All rights reserved.
//
// This computer source code and related instructions and comments
// are the unpublished confidential and proprietary information of
// Autodesk, Inc. and are protected under applicable copyright and
// trade secret law.  They may not be disclosed to, copied or used
// by any third party without the prior written consent of Autodesk, Inc.
//
//////////////////////////////////////////////////////////////////////////////

$.Class('util',
//static methods
{
getUrlVars: function (urlPath) {
    var vars = {}, hash;
    var hashes = urlPath.slice(urlPath.indexOf('?') + 1).split('&');
    for (var i = 0; i < hashes.length; i++) {
        hash = hashes[i].split('=');
        vars[hash[0]] = hash[1];
    }

    return vars;
}
},
//instance methods
{
});

(function ($) {
    $.watermark = function(target, label, options){
        var self = this;
        self.labelVisible = true;
        if (target.val() !== "" )
        {
                label.hide();
                self.labelVisible = false;
        }

        target.focus( function(){
            if (self.labelVisible)
                self.setOpacityForLabel(0.5);
        });

        target.blur( function(){
             self.checkIfTargetEmpty();
        });
        target.bind("keydown.watermark", function(e) {
            self.handleKeydownEvent(e);
        });
        target.bind("keyup.watermark", function(e){
            self.checkIfTargetEmpty();
        });
        target.bind("paste", function(e) {
            //paste can never be emptied so we shall always hide watermark
            self.hideWatermark();
        });
        target.bind("cut", function(e){
            /*this event is triggered before the text is changed
            so using setTimeout 9to delay the checking whether textbox state is empty to
            subsequent event loop. This cut event is handled because 'change' event does not work always.
            */
            setTimeout(self.checkIfTargetEmpty, 0);
        });
        target.bind("change", function (e) {
            self.checkIfTargetEmpty();
        });
        target.bind('onpropertychange', function (e) {
            self.checkIfTargetEmpty(e);
        });

        self.setOpacityForLabel = function(opacity) {
            label.stop().animate({opacity: opacity}, 300);
            self.labelVisible = opacity > 0.0;
        };

        self.checkIfTargetEmpty = function(){
          if (target.val() === ""){
                label.css({opacity:0.0}).show();
                self.setOpacityForLabel( 0.5);
          } else{
                self.setOpacityForLabel(0.0);
          }
        };

        self.handleKeydownEvent= function(e){
            if ( e.keyCode === 9 ||  //shift
                 e.keyCode === 16)   //tab
                 return;
            self.hideWatermark();
        };

        self.hideWatermark = function()
        {
            if (self.labelVisible)
            {
                label.hide();
                self.labelVisible = false;
            }
        };
        self.setOpacityForLabel(0.5);
    };

    $.fn.marktext = function (options) {
        return this.each(
			function () {

                var target_id = $(this).attr('target');
                if (!target_id) {
                    return ;
                }
                var label = $(this);
                $(this).siblings().each(function(){
                    if ($(this).attr('id') != target_id)
                        return;
                    return new $.watermark($(this), label, options);
                });
			}
		);
    };
})(jQuery);

/*Global Variables*/
    var globalQueries = util.getUrlVars(window.location.href);
    var SELECTED_LANG = 'en-US';
    var IS_ONLINE_MODE = navigator.onLine;
    var LUPREC = 6;
    var TIME_OUT = 16000;
    var CAN_CANCEL = false;
/****End of global variables***///

//register callback so acgeolocation arx can call this function
if (typeof (registerCallback) === 'function') {
    registerCallback("updateDialogWithoutReload", updateDialogWithoutReload);
	registerCallback("closeDialog", closeDialog);
}

function closeDialog() {
    if(CAN_CANCEL) {
        $('#cancelButton').focus(); //need to change the focus out of lat/lang/elevation text boxes that will trigger validation check
        ButtonsRowController.geoLocationMapDlgInvokeCancel();
    }
}

function getParamForceOffline() {
    var is_forceoffline = 0;
    if (globalQueries.hasOwnProperty('force_offline')) {
        is_forceoffline = parseInt(globalQueries['force_offline']);
    }
    return is_forceoffline;
}

function refreshDialog() {    
    //destroy marker
    if ($('#markerInfoAndListCS').controllers().length != 0) {
        $('#markerInfoAndListCS').marker_location('destroy');
    }
    $('#markerInfoAndListCS').html("");

    //destroy map
    if ($('#addressSearchSection').controllers().length != 0) {
        $('#addressSearchSection').search_address_map('destroy');
    }
    $('#addressSearchSection').html("");

    //destroy coord sys
    if ($('#coordSysSection').controllers().length != 0) {
        $('#coordSysSection').coord_sys('destroy');
    }

    //start all over again
    initMap();
}

function updateDialogWithoutReload(newURL) {
    if (!newURL) {
        return;
    }
    newURL = newURL.replace("'", "\'");
    var paramObj = JSON.parse(newURL);
    if (paramObj && paramObj.url && typeof (paramObj.url) === 'string') {
        var is_online_prev = IS_ONLINE_MODE;
        globalQueries = util.getUrlVars(paramObj.url);
        IS_ONLINE_MODE = 1 - getParamForceOffline();
        if (!is_online_prev && IS_ONLINE_MODE) { //last time is offline, now is online, we better refresh all controllers
            refreshDialog();
        } else {
            $('#addressSearchSection').search_address_map("populateCurrentLocation");
        }
    }
}

function setLoadingState(state) {
    if (0 == state) { //waiting
        $('#loading').removeClass('loading-invisible');
        $('#loading').addClass('loading-visible');
    } else {
        $('#loading').removeClass('loading-visible');
        $('#loading').addClass('loading-invisible');
    }
}

function initializeController() {
    setLoadingState(1);
	$('#addressSearchSection').search_address_map();
}

function initializeOfflineMode() {
    IS_ONLINE_MODE = false;
    setLoadingState(1);
    $('#addressSearchSection').search_address_map();
}

function initMap() {

    setLoadingState(0);
    if (IS_ONLINE_MODE) {

        var MAP_CULTURE = SELECTED_LANG;
        //if map does not support the culture, fall back to default en-US
        if (!MapServiceProvider.isSupportedCultures(MAP_CULTURE)) {
            MAP_CULTURE = 'en-US';
        }
        var mapPath = "http://ecn.dev.virtualearth.net/mapcontrol/mapcontrol.ashx?v=7.0&mkt=";
        mapPath = mapPath + MAP_CULTURE;
        mapPath = mapPath + "&timeToAvoidCache=" + Date.now(); //to avoid cache

        TIME_OUT = 16000;
        if (globalQueries.hasOwnProperty('time_out')) {
            var timeStr = globalQueries['time_out'];
            TIME_OUT = parseInt(timeStr);
        }
        if (TIME_OUT == 0)
            TIME_OUT = 16000;

        var params = { fnIsComponentLoaded: MapServiceProvider.isMapLoaded,
            path: mapPath,
            num_try: TIME_OUT / LoadJSDynamic.TimeOut,
            callback: initializeController,
            failedLoadCallback: initializeOfflineMode
        };
        LoadJSDynamic.LoadJS(params);
    } else {
        initializeOfflineMode();
    }
}

function main() {
    var culture = 'en-US';
    if (globalQueries.hasOwnProperty('culture')) {
        culture = globalQueries['culture'];
    }

    if (globalQueries.hasOwnProperty('luprec')) {
        LUPREC = parseInt(globalQueries['luprec']);
    }

    IS_ONLINE_MODE = 1 - getParamForceOffline();

    SELECTED_LANG = culture;
    var localFolder = "./assets/js/local/" + SELECTED_LANG + "/";
    var cssFile = localFolder + "geo_map.css";
    $('#styleSheetForDialog').attr('href', cssFile);

    // prevent right click context menu from showing unless
    // the element has 'contextmenu' class defined
    $(document).bind("contextmenu", function(e) {
        return $(e.target).hasClass('contextmenu');
    });

    var langFile = localFolder + "strings.js";
    LoadJSDynamic.AppendJSfile(langFile, initMap);
    
    // just a failsafe to make sure we don't get into the situation whereby
    // the dialog can't be cancelled
    setTimeout(function() {
                    CAN_CANCEL = true;
                }, IS_ONLINE_MODE ? 8000 : 1000);
}

//Register event handlers after DOM is loaded.
$(document).ready(function () {
    $('body').keydown(function (event) {
        if (MarkerLocationController.handleKeyDownEvent(event))
            return;

        if (SearchAddressMapController.handleKeyDownEvent(event))
            return;
            
        if (CoordSysController.handleKeyDownEvent(event))
            return;
            
        if (event.keyCode == 27) { // ESC
            closeDialog();
        }
    });

    $('body').mousedown(function(e){
		if(e.button==1) //middle button is disable
		    return false;
	});
});


// SIG // Begin signature block
// SIG // MIIZNgYJKoZIhvcNAQcCoIIZJzCCGSMCAQExCzAJBgUr
// SIG // DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
// SIG // gjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIBAAIB
// SIG // AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFJNf4sAPhfco
// SIG // YytjpaEZoSIJhWuEoIIUMDCCA+4wggNXoAMCAQICEH6T
// SIG // 6/t8xk5Z6kuad9QG/DswDQYJKoZIhvcNAQEFBQAwgYsx
// SIG // CzAJBgNVBAYTAlpBMRUwEwYDVQQIEwxXZXN0ZXJuIENh
// SIG // cGUxFDASBgNVBAcTC0R1cmJhbnZpbGxlMQ8wDQYDVQQK
// SIG // EwZUaGF3dGUxHTAbBgNVBAsTFFRoYXd0ZSBDZXJ0aWZp
// SIG // Y2F0aW9uMR8wHQYDVQQDExZUaGF3dGUgVGltZXN0YW1w
// SIG // aW5nIENBMB4XDTEyMTIyMTAwMDAwMFoXDTIwMTIzMDIz
// SIG // NTk1OVowXjELMAkGA1UEBhMCVVMxHTAbBgNVBAoTFFN5
// SIG // bWFudGVjIENvcnBvcmF0aW9uMTAwLgYDVQQDEydTeW1h
// SIG // bnRlYyBUaW1lIFN0YW1waW5nIFNlcnZpY2VzIENBIC0g
// SIG // RzIwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIB
// SIG // AQCxrLNJVEuXHBIK2CV5kSJXKm/cuCbEQ3Nrwr8uUFr7
// SIG // FMJ2jkMBJUO0oeJF9Oi3e8N0zCLXtJQAAvdN7b+0t0Qk
// SIG // a81fRTvRRM5DEnMXgotptCvLmR6schsmTXEfsTHd+1Fh
// SIG // AlOmqvVJLAV4RaUvic7nmef+jOJXPz3GktxK+Hsz5HkK
// SIG // +/B1iEGc/8UDUZmq12yfk2mHZSmDhcJgFMTIyTsU2sCB
// SIG // 8B8NdN6SIqvK9/t0fCfm90obf6fDni2uiuqm5qonFn1h
// SIG // 95hxEbziUKFL5V365Q6nLJ+qZSDT2JboyHylTkhE/xni
// SIG // RAeSC9dohIBdanhkRc1gRn5UwRN8xXnxycFxAgMBAAGj
// SIG // gfowgfcwHQYDVR0OBBYEFF+a9W5czMx0mtTdfe8/2+xM
// SIG // gC7dMDIGCCsGAQUFBwEBBCYwJDAiBggrBgEFBQcwAYYW
// SIG // aHR0cDovL29jc3AudGhhd3RlLmNvbTASBgNVHRMBAf8E
// SIG // CDAGAQH/AgEAMD8GA1UdHwQ4MDYwNKAyoDCGLmh0dHA6
// SIG // Ly9jcmwudGhhd3RlLmNvbS9UaGF3dGVUaW1lc3RhbXBp
// SIG // bmdDQS5jcmwwEwYDVR0lBAwwCgYIKwYBBQUHAwgwDgYD
// SIG // VR0PAQH/BAQDAgEGMCgGA1UdEQQhMB+kHTAbMRkwFwYD
// SIG // VQQDExBUaW1lU3RhbXAtMjA0OC0xMA0GCSqGSIb3DQEB
// SIG // BQUAA4GBAAMJm495739ZMKrvaLX64wkdu0+CBl03X6ZS
// SIG // nxaN6hySCURu9W3rWHww6PlpjSNzCxJvR6muORH4KrGb
// SIG // sBrDjutZlgCtzgxNstAxpghcKnr84nodV0yoZRjpeUBi
// SIG // JZZux8c3aoMhCI5B6t3ZVz8dd0mHKhYGXqY4aiISo1EZ
// SIG // g362MIIEozCCA4ugAwIBAgIQDs/0OMj+vzVuBNhqmBsa
// SIG // UDANBgkqhkiG9w0BAQUFADBeMQswCQYDVQQGEwJVUzEd
// SIG // MBsGA1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24xMDAu
// SIG // BgNVBAMTJ1N5bWFudGVjIFRpbWUgU3RhbXBpbmcgU2Vy
// SIG // dmljZXMgQ0EgLSBHMjAeFw0xMjEwMTgwMDAwMDBaFw0y
// SIG // MDEyMjkyMzU5NTlaMGIxCzAJBgNVBAYTAlVTMR0wGwYD
// SIG // VQQKExRTeW1hbnRlYyBDb3Jwb3JhdGlvbjE0MDIGA1UE
// SIG // AxMrU3ltYW50ZWMgVGltZSBTdGFtcGluZyBTZXJ2aWNl
// SIG // cyBTaWduZXIgLSBHNDCCASIwDQYJKoZIhvcNAQEBBQAD
// SIG // ggEPADCCAQoCggEBAKJjCzlEuLsjp0RJuw7/ofBhClOT
// SIG // sJjbrSwPSsVu/4Y8U1UPFc4EPyv9qZaW2b5heQtbyUyG
// SIG // duXgQ0sile7CK0PBn9hotI5AT+6FOLkRxSPyZFjwFTJv
// SIG // TlehroikAtcqHs1L4d1j1ReJMluwXplaqJ0oUA4X7pbb
// SIG // YTtFUR3PElYLkkf8q672Zj1HrHBy55LnX80QucSDZJQZ
// SIG // vSWA4ejSIqXQugJ6oXeTW2XD7hd0vEGGKtwITIySjJEt
// SIG // nndEH2jWqHR32w5bMotWizO92WPISZ06xcXqMwvS8aMb
// SIG // 9Iu+2bNXizveBKd6IrIkri7HcMW+ToMmCPsLvalPmQjh
// SIG // EChyqs0CAwEAAaOCAVcwggFTMAwGA1UdEwEB/wQCMAAw
// SIG // FgYDVR0lAQH/BAwwCgYIKwYBBQUHAwgwDgYDVR0PAQH/
// SIG // BAQDAgeAMHMGCCsGAQUFBwEBBGcwZTAqBggrBgEFBQcw
// SIG // AYYeaHR0cDovL3RzLW9jc3Aud3Muc3ltYW50ZWMuY29t
// SIG // MDcGCCsGAQUFBzAChitodHRwOi8vdHMtYWlhLndzLnN5
// SIG // bWFudGVjLmNvbS90c3MtY2EtZzIuY2VyMDwGA1UdHwQ1
// SIG // MDMwMaAvoC2GK2h0dHA6Ly90cy1jcmwud3Muc3ltYW50
// SIG // ZWMuY29tL3Rzcy1jYS1nMi5jcmwwKAYDVR0RBCEwH6Qd
// SIG // MBsxGTAXBgNVBAMTEFRpbWVTdGFtcC0yMDQ4LTIwHQYD
// SIG // VR0OBBYEFEbGaaMOShQe1UzaUmMXP142vA3mMB8GA1Ud
// SIG // IwQYMBaAFF+a9W5czMx0mtTdfe8/2+xMgC7dMA0GCSqG
// SIG // SIb3DQEBBQUAA4IBAQB4O7SRKgBM8I9iMDd4o4QnB28Y
// SIG // st4l3KDUlAOqhk4ln5pAAxzdzuN5yyFoBtq2MrRtv/Qs
// SIG // JmMz5ElkbQ3mw2cO9wWkNWx8iRbG6bLfsundIMZxD82V
// SIG // dNy2XN69Nx9DeOZ4tc0oBCCjqvFLxIgpkQ6A0RH83Vx2
// SIG // bk9eDkVGQW4NsOo4mrE62glxEPwcebSAe6xp9P2ctgwW
// SIG // K/F/Wwk9m1viFsoTgW0ALjgNqCmPLOGy9FqpAa8VnCwv
// SIG // SRvbIrvD/niUUcOGsYKIXfA9tFGheTMrLnu53CAJE3Hr
// SIG // ahlbz+ilMFcsiUk/uc9/yb8+ImhjU5q9aXSsxR08f5Lg
// SIG // w7wc2AR1MIIFhTCCBG2gAwIBAgIQKcFbP6rNUmpOZ708
// SIG // Tn4/8jANBgkqhkiG9w0BAQUFADCBtDELMAkGA1UEBhMC
// SIG // VVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMR8wHQYD
// SIG // VQQLExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMTswOQYD
// SIG // VQQLEzJUZXJtcyBvZiB1c2UgYXQgaHR0cHM6Ly93d3cu
// SIG // dmVyaXNpZ24uY29tL3JwYSAoYykxMDEuMCwGA1UEAxMl
// SIG // VmVyaVNpZ24gQ2xhc3MgMyBDb2RlIFNpZ25pbmcgMjAx
// SIG // MCBDQTAeFw0xMjA3MjUwMDAwMDBaFw0xNTA5MjAyMzU5
// SIG // NTlaMIHIMQswCQYDVQQGEwJVUzETMBEGA1UECBMKQ2Fs
// SIG // aWZvcm5pYTETMBEGA1UEBxMKU2FuIFJhZmFlbDEWMBQG
// SIG // A1UEChQNQXV0b2Rlc2ssIEluYzE+MDwGA1UECxM1RGln
// SIG // aXRhbCBJRCBDbGFzcyAzIC0gTWljcm9zb2Z0IFNvZnR3
// SIG // YXJlIFZhbGlkYXRpb24gdjIxHzAdBgNVBAsUFkRlc2ln
// SIG // biBTb2x1dGlvbnMgR3JvdXAxFjAUBgNVBAMUDUF1dG9k
// SIG // ZXNrLCBJbmMwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAw
// SIG // ggEKAoIBAQCoYmDrmd0Gq8ezSsDlfgaJFEFplNPNhWzM
// SIG // 2uFQaYAB/ggpQ11+N4B6ao+TqrNIWDIqt3JKhaU889nx
// SIG // l/7teWGwuOurstI2Z0bEDhXiXam/bicK2HVLyntliQ+6
// SIG // tT+nlgfN8tgB2NzM0BpE1YCnU2b6DwQw4V7BV+/F//83
// SIG // yGFOpePlumzXxNw9EKWkaq81slmmTxf7UxZgP9PGbLw8
// SIG // gLAPk4PTJI97+5BBqhkLb1YqSfWn3PNMfsNKhw/VwAN0
// SIG // dRKeM6H8SkOdz+osr+NyH86lsKQuics4fwK5uFSHQHsI
// SIG // t6Z0tqWvminRqceUi9ugRlGryh9X1ZqCqfL/ggdzYa3Z
// SIG // AgMBAAGjggF7MIIBdzAJBgNVHRMEAjAAMA4GA1UdDwEB
// SIG // /wQEAwIHgDBABgNVHR8EOTA3MDWgM6Axhi9odHRwOi8v
// SIG // Y3NjMy0yMDEwLWNybC52ZXJpc2lnbi5jb20vQ1NDMy0y
// SIG // MDEwLmNybDBEBgNVHSAEPTA7MDkGC2CGSAGG+EUBBxcD
// SIG // MCowKAYIKwYBBQUHAgEWHGh0dHBzOi8vd3d3LnZlcmlz
// SIG // aWduLmNvbS9ycGEwEwYDVR0lBAwwCgYIKwYBBQUHAwMw
// SIG // cQYIKwYBBQUHAQEEZTBjMCQGCCsGAQUFBzABhhhodHRw
// SIG // Oi8vb2NzcC52ZXJpc2lnbi5jb20wOwYIKwYBBQUHMAKG
// SIG // L2h0dHA6Ly9jc2MzLTIwMTAtYWlhLnZlcmlzaWduLmNv
// SIG // bS9DU0MzLTIwMTAuY2VyMB8GA1UdIwQYMBaAFM+Zqep7
// SIG // JvRLyY6P1/AFJu/j0qedMBEGCWCGSAGG+EIBAQQEAwIE
// SIG // EDAWBgorBgEEAYI3AgEbBAgwBgEBAAEB/zANBgkqhkiG
// SIG // 9w0BAQUFAAOCAQEA2OkGvuiY7TyI6yVTQAYmTO+MpOFG
// SIG // C8MflHSbofJiuLxrS1KXbkzsAPFPPsU1ouftFhsXFtDQ
// SIG // 8rMTq/jwugTpbJUREV0buEkLl8AKRhYQTKBKg1I/puBv
// SIG // bkJocDE0pRwtBz3xSlXXEwyYPcbCOnrM3OZ5bKx1Qiii
// SIG // vixlcGWhO3ws904ssutPFf4mV5PDi3U2Yp1HgbBK/Um/
// SIG // FLr6YAYeZaA8KY1CfQEisF3UKTwm72d7S+fJf++SOGea
// SIG // K0kumehVcbavQJTOVebuZ9V+qU0nk1lMrqve9BnQK69B
// SIG // QqNZu77vCO0wm81cfynAxkOYKZG3idY47qPJOgXKkwmI
// SIG // 2+92ozCCBgowggTyoAMCAQICEFIA5aolVvwahu2WydRL
// SIG // M8cwDQYJKoZIhvcNAQEFBQAwgcoxCzAJBgNVBAYTAlVT
// SIG // MRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5jLjEfMB0GA1UE
// SIG // CxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29yazE6MDgGA1UE
// SIG // CxMxKGMpIDIwMDYgVmVyaVNpZ24sIEluYy4gLSBGb3Ig
// SIG // YXV0aG9yaXplZCB1c2Ugb25seTFFMEMGA1UEAxM8VmVy
// SIG // aVNpZ24gQ2xhc3MgMyBQdWJsaWMgUHJpbWFyeSBDZXJ0
// SIG // aWZpY2F0aW9uIEF1dGhvcml0eSAtIEc1MB4XDTEwMDIw
// SIG // ODAwMDAwMFoXDTIwMDIwNzIzNTk1OVowgbQxCzAJBgNV
// SIG // BAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5jLjEf
// SIG // MB0GA1UECxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29yazE7
// SIG // MDkGA1UECxMyVGVybXMgb2YgdXNlIGF0IGh0dHBzOi8v
// SIG // d3d3LnZlcmlzaWduLmNvbS9ycGEgKGMpMTAxLjAsBgNV
// SIG // BAMTJVZlcmlTaWduIENsYXNzIDMgQ29kZSBTaWduaW5n
// SIG // IDIwMTAgQ0EwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAw
// SIG // ggEKAoIBAQD1I0tepdeKuzLp1Ff37+THJn6tGZj+qJ19
// SIG // lPY2axDXdYEwfwRof8srdR7NHQiM32mUpzejnHuA4Jnh
// SIG // 7jdNX847FO6G1ND1JzW8JQs4p4xjnRejCKWrsPvNamKC
// SIG // TNUh2hvZ8eOEO4oqT4VbkAFPyad2EH8nA3y+rn59wd35
// SIG // BbwbSJxp58CkPDxBAD7fluXF5JRx1lUBxwAmSkA8taEm
// SIG // qQynbYCOkCV7z78/HOsvlvrlh3fGtVayejtUMFMb32I0
// SIG // /x7R9FqTKIXlTBdOflv9pJOZf9/N76R17+8V9kfn+Bly
// SIG // 2C40Gqa0p0x+vbtPDD1X8TDWpjaO1oB21xkupc1+NC2J
// SIG // AgMBAAGjggH+MIIB+jASBgNVHRMBAf8ECDAGAQH/AgEA
// SIG // MHAGA1UdIARpMGcwZQYLYIZIAYb4RQEHFwMwVjAoBggr
// SIG // BgEFBQcCARYcaHR0cHM6Ly93d3cudmVyaXNpZ24uY29t
// SIG // L2NwczAqBggrBgEFBQcCAjAeGhxodHRwczovL3d3dy52
// SIG // ZXJpc2lnbi5jb20vcnBhMA4GA1UdDwEB/wQEAwIBBjBt
// SIG // BggrBgEFBQcBDARhMF+hXaBbMFkwVzBVFglpbWFnZS9n
// SIG // aWYwITAfMAcGBSsOAwIaBBSP5dMahqyNjmvDz4Bq1EgY
// SIG // LHsZLjAlFiNodHRwOi8vbG9nby52ZXJpc2lnbi5jb20v
// SIG // dnNsb2dvLmdpZjA0BgNVHR8ELTArMCmgJ6AlhiNodHRw
// SIG // Oi8vY3JsLnZlcmlzaWduLmNvbS9wY2EzLWc1LmNybDA0
// SIG // BggrBgEFBQcBAQQoMCYwJAYIKwYBBQUHMAGGGGh0dHA6
// SIG // Ly9vY3NwLnZlcmlzaWduLmNvbTAdBgNVHSUEFjAUBggr
// SIG // BgEFBQcDAgYIKwYBBQUHAwMwKAYDVR0RBCEwH6QdMBsx
// SIG // GTAXBgNVBAMTEFZlcmlTaWduTVBLSS0yLTgwHQYDVR0O
// SIG // BBYEFM+Zqep7JvRLyY6P1/AFJu/j0qedMB8GA1UdIwQY
// SIG // MBaAFH/TZafC3ey78DAJ80M5+gKvMzEzMA0GCSqGSIb3
// SIG // DQEBBQUAA4IBAQBWIuY0pMRhy0i5Aa1WqGQP2YyRxLvM
// SIG // DOWteqAif99HOEotbNF/cRp87HCpsfBP5A8MU/oVXv50
// SIG // mEkkhYEmHJEUR7BMY4y7oTTUxkXoDYUmcwPQqYxkbdxx
// SIG // kuZFBWAVWVE5/FgUa/7UpO15awgMQXLnNyIGCb4j6T9E
// SIG // mh7pYZ3MsZBc/D3SjaxCPWU21LQ9QCiPmxDPIybMSyDL
// SIG // kB9djEw0yjzY5TfWb6UgvTTrJtmuDefFmvehtCGRM2+G
// SIG // 6Fi7JXx0Dlj+dRtjP84xfJuPG5aexVN2hFucrZH6rO2T
// SIG // ul3IIVPCglNjrxINUIcRGz1UUpaKLJw9khoImgUux5Ol
// SIG // SJHTMYIEcjCCBG4CAQEwgckwgbQxCzAJBgNVBAYTAlVT
// SIG // MRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5jLjEfMB0GA1UE
// SIG // CxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29yazE7MDkGA1UE
// SIG // CxMyVGVybXMgb2YgdXNlIGF0IGh0dHBzOi8vd3d3LnZl
// SIG // cmlzaWduLmNvbS9ycGEgKGMpMTAxLjAsBgNVBAMTJVZl
// SIG // cmlTaWduIENsYXNzIDMgQ29kZSBTaWduaW5nIDIwMTAg
// SIG // Q0ECECnBWz+qzVJqTme9PE5+P/IwCQYFKw4DAhoFAKBw
// SIG // MBAGCisGAQQBgjcCAQwxAjAAMBkGCSqGSIb3DQEJAzEM
// SIG // BgorBgEEAYI3AgEEMBwGCisGAQQBgjcCAQsxDjAMBgor
// SIG // BgEEAYI3AgEVMCMGCSqGSIb3DQEJBDEWBBQ4+5JpvEp8
// SIG // EzXNDnewruDAtp6mHjANBgkqhkiG9w0BAQEFAASCAQB2
// SIG // qI67GY+SZF1kYtvLFDudt9Vk8aI/7q8T28KLeT+Axnz9
// SIG // X4rIPqXffrxxq0pwTjpqcuXE0lRosmCnV98hRBnDjSPw
// SIG // /MM7QpE87h33Xv6aGUbbpk261JCd/XJt5U2tOG8v6eY9
// SIG // bdGXC1KwjyjpftRmRgBd4OVk7A1+TYYhTOpDdvUNBvuY
// SIG // sbOtpFO4TjAgBEVESXTDoZ1nPGGqYUf44g/2nwuA6Qus
// SIG // uLhw2FL/ZJPaaYj1fNJXEB/WS6c+8zeJdXsxf9iSObau
// SIG // ujMk7E5Pmerd3I2kcFZrOLX3FgExf1QT6/7JjjaLMY/j
// SIG // qKpLPgcZzyTr1KODyQMXCbxdp4THHOPfoYICCzCCAgcG
// SIG // CSqGSIb3DQEJBjGCAfgwggH0AgEBMHIwXjELMAkGA1UE
// SIG // BhMCVVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0
// SIG // aW9uMTAwLgYDVQQDEydTeW1hbnRlYyBUaW1lIFN0YW1w
// SIG // aW5nIFNlcnZpY2VzIENBIC0gRzICEA7P9DjI/r81bgTY
// SIG // apgbGlAwCQYFKw4DAhoFAKBdMBgGCSqGSIb3DQEJAzEL
// SIG // BgkqhkiG9w0BBwEwHAYJKoZIhvcNAQkFMQ8XDTE0MDIw
// SIG // NzExMTQwOVowIwYJKoZIhvcNAQkEMRYEFLO94QrvT6eF
// SIG // Z9ZOj0WFWYwgQKWVMA0GCSqGSIb3DQEBAQUABIIBAG5D
// SIG // qrn6OxLN60/wWAJk0HVi/ZIRSrST2y5tNjXU+v7CQ5ag
// SIG // BndAYeQ0eISK9JNktlkBKoeNzNt8qZ03u48NS3O9wB9g
// SIG // RXF3MPtjB9+WTRqnO2H8KFenOT7tSb4AkcHiaCydT4u0
// SIG // RL8q9rSQD8AfVRblzX9EQGsqgJYM31uGSyglyv06BHzj
// SIG // DrFA/GWbVS69gCaeNdx8XU2JOtcNlEZhFoXYnLnQiSeC
// SIG // qQhRhCPeawfWSHZvbOubamkYwKRKATiBMQn+jYFw31bb
// SIG // EWC+du7UEpO2krvIU2BO16gFgXu+upgLe8f2EZXOsGQP
// SIG // lppgTkq8ZfOYql7VYIrzC16sQ+O8lks=
// SIG // End signature block
